%define _unpackaged_files_terminate_build 1

%define modname py9p

Name: python3-module-%modname
Version: 1.0.9
Release: alt3

Summary: Pure Python implementation of 9P protocol (Plan9)
License: MIT
Group: Development/Python3
URL: https://github.com/svinota/py9p
BuildArch: noarch

Source: py9p-%version.tar

BuildRequires(pre): rpm-build-python3

%description
Protocol 9P is developed for Plan9 operating system from Bell Labs.
It is used for remote file access, and since files are key objects
in Plan9, 9P can be used also for composite file access, RPC etc.

This library provides low-level 9p2000.u API. For high-level look
into python-module-pyvfs.

%package -n fuse9p
Summary: Plan9 filesystem client for FUSE
License: MIT
Group: Development/Python

%description -n fuse9p
Protocol 9P is developed for Plan9 operating system from Bell Labs.
It is used for remote file access, and since files are key objects
in Plan9, 9P can be used also for composite file access, RPC etc.

This package contains FUSE client for the 9p protocol.

%package -n 9pfs
Summary: Plan9 filesystem server
License: MIT
Group: Development/Python

%description -n 9pfs
Protocol 9P is developed for Plan9 operating system from Bell Labs.
It is used for remote file access, and since files are key objects
in Plan9, 9P can be used also for composite file access, RPC etc.

This package contains simple 9p2000 file server.

%prep
%setup -n py9p-%{version}

%build
make force-version
%python3_build

%install
%python3_install

%files
%doc README* LICENSE
%{python3_sitelibdir}/*

%files -n fuse9p
%doc LICENSE
%_bindir/fuse9p
%_man1dir/fuse9p.*

%files -n 9pfs
%doc LICENSE
%_bindir/9pfs
%_man1dir/9pfs.*

%changelog
