%define oname psycopg2

# tests require running PGSQL
%def_without check

Name: python3-module-%oname
Version: 2.9.11
Release: alt1

Summary: psycopg2 is a PostgreSQL database adapter for Python3

License: LGPLv3+
Group: Development/Python3
URL: https://pypi.org/project/psycopg2
VCS: https://github.com/psycopg/psycopg2
Source0: %name-%version.tar

BuildRequires(pre): rpm-build-python3
BuildRequires: postgresql-devel python3-devel

BuildRequires: python3-module-setuptools
BuildRequires: python3-module-wheel

%description
psycopg is a PostgreSQL database adapter for the Python programming
language (just like pygresql and popy.) It was written from scratch with
the aim of being very small and fast, and stable as a rock. The main
advantages of psycopg are that it supports the full Python DBAPI-2.0 and
being thread safe at level 2.

%package doc
Summary: Documentation for psycopg2 python PostgreSQL database adapter
Group: Development/Python
BuildArch: noarch

%description doc
Documenation and example files for the psycopg2 python PostgreSQL
database adapter.

%prep
%setup

echo "include_dirs=.:/usr/include/pgsql" >> setup.cfg

%build
%add_optflags -fno-strict-aliasing
%pyproject_build

%install
%pyproject_install

%files
%doc LICENSE AUTHORS NEWS *.rst
%python3_sitelibdir/%oname
%python3_sitelibdir/%oname-%version.dist-info

%files doc
%doc AUTHORS INSTALL README* doc

%changelog
