%define        _unpackaged_files_terminate_build 1
%define        pypiname psycopg
%define        modname psycopg
%define        distname psycopg
%def_disable   doc

Name:          python3-module-%pypiname
Version:       3.2.12
Release:       alt1
Summary:       psycopg is a PostgreSQL database adapter for Python
License:       LGPL-3.0
Group:         Development/Python3
Url:           https://www.psycopg.org/psycopg3/
Vcs:           https://github.com/psycopg/psycopg.git
Packager:      Python Development Team <python@packages.altlinux.org>
BuildArch:     noarch

Source:        %name-%version.tar
BuildRequires(pre): rpm-build-python3
BuildRequires: postgresql-devel
BuildRequires: python3(setuptools)
BuildRequires: python3(wheel)
%if_enabled doc
BuildRequires: python3(typing_extensions)
BuildRequires: python3(sphinx_autodoc_typehints)
BuildRequires: python3(furo)
BuildRequires: python3-module-sphinx-sphinx-build-symlink
%endif
Obsoletes:     psycopg <= 1.1.9-alt4

%description
psycopg is a PostgreSQL database adapter for the Python programming
language (just like pygresql and popy.) It was written from scratch with
the aim of being very small and fast, and stable as a rock. The main
advantages of psycopg are that it supports the full Python DBAPI-2.0 and
being thread safe at level 2.

Psycopg 3 design emerges from the experience of more than 10 years of
development and support of psycopg2. It embraces the new possibilities offered
by the more modern generations of the Python language and the PostgreSQL
database and addresses the challenges offered by the current patterns in
software development and deployment.


%package       doc
Summary:       Documentation for psycopg python PostgreSQL database adapter
Group:         Development/Documentation

%description   doc
Documenation and example files for the psycopg python PostgreSQL
database adapter.


%prep
%setup

%build
pushd psycopg
%pyproject_build
popd
export PYTHONPATH=$(pwd)/psycopg
%{?!_disable_doc:%make -C docs html SPHINXBUILD=sphinx-build-3}

%install
pushd psycopg
%pyproject_install
popd

%files
%doc *.rst
%{?!_disable_doc:%doc docs/build/html/*}
%python3_sitelibdir/%{distname}
%python3_sitelibdir/%{modname}*/METADATA


%files         doc
%doc *.rst docs


%changelog
