%define _unpackaged_files_terminate_build 1
%define oname proteus

%def_with bootstrap
%def_with check

Name: python3-module-%oname
Version: 7.6.1
Release: alt1

Summary: Library to access Tryton server as a client
License: GPL-3
Group: Development/Python3
Url: https://pypi.org/project/proteus/

Source: %name-%version.tar
BuildArch: noarch

BuildRequires(pre): rpm-build-python3
BuildRequires: python3-module-setuptools
BuildRequires: python3-module-wheel

%if_with check
BuildRequires: python3-modules-sqlite3
BuildRequires: python3-module-pytest
BuildRequires: python3-module-trytond-tests
BuildRequires: python3-module-pwdlib
BuildRequires: python3-module-argon2-cffi
BuildRequires: python3-module-pydot
%endif

%if_without bootstrap
Requires: python3-module-trytond python3-module-trytond_party
%endif

%py_provides %oname

%description
A library to access Tryton's models like a client.

%package tests
Summary: Tests for %oname
Group: Development/Python3
Requires: %name = %EVR
%if_with bootstrap
%add_python3_req_skip trytond.tests.test_tryton
%endif

%description tests
A library to access Tryton's models like a client.

This package contains tests for %oname.

%prep
%setup

%build
%pyproject_build

%install
%pyproject_install

%check
%pyproject_run_pytest -v

%files
%doc CHANGELOG COPYRIGHT LICENSE README.rst doc/*
%python3_sitelibdir/*
%exclude %python3_sitelibdir/*/tests

%files tests
%python3_sitelibdir/*/tests


%changelog
