%define oname progressbar2
%def_with check

Name: python3-module-%oname
Version: 4.5.0
Release: alt1

Summary: Text progress bar library for Python

License: LGPLv2.1+ or BSD
Group: Development/Python3
URL: https://pypi.org/project/progressbar2
VCS: https://github.com/WoLpH/python-progressbar

Source: %name-%version.tar
Patch1: %oname-3.34.4-alt-doc.patch

BuildRequires(pre): rpm-build-python3
BuildRequires: python3-module-setuptools
BuildRequires: python3-module-wheel

%if_with check
BuildRequires: python3-module-pytest
BuildRequires: python3-module-freezegun
BuildRequires: python3-module-python_utils
BuildRequires: python3-module-dill
%endif

BuildArch: noarch

Conflicts: python3-module-progressbar

%description
A text progress bar is typically used to display the progress of a long
running operation, providing a visual cue that processing is underway.

The ProgressBar class manages the current progress, and the format of
the line is given by a number of widgets. A widget is an object that may
display differently depending on the state of the progress bar.

%prep
%setup
%patch1 -p1

%build
%pyproject_build

%install
%pyproject_install

%check
sed -i '/cov/d' pytest.ini
%pyproject_run_pytest

%files
%doc LICENSE examples.py *.rst
%_bindir/progressbar
%python3_sitelibdir/progressbar
%python3_sitelibdir/%oname-%version.dist-info

%changelog
