%define oname pifpaf

%def_without check

Name: python3-module-%oname
Version: 3.4.0
Release: alt1

Summary: Suite of tools and fixtures to manage daemons for testing

Group: Development/Python3
License: Apache-2.0
URL: https://pypi.org/project/pifpaf
VCS: https://github.com/jd/pifpaf

Source: %name-%version.tar

BuildArch: noarch

BuildRequires(pre): rpm-build-python3
BuildRequires: python3-module-setuptools
BuildRequires: python3-module-setuptools-scm
BuildRequires: python3-module-wheel

%if_with check
BuildRequires: python3-module-pytest
BuildRequires: python3-module-fixtures
BuildRequires: python3-module-jinja2
BuildRequires: python3-module-daiquiri
BuildRequires: python3-module-psutil
BuildRequires: python3-module-pyxattr
BuildRequires: python3-module-requests
BuildRequires: memcached
%endif

%add_python3_req_skip swift.common

%description
Pifpaf is a suite of fixtures and a command-line tool that allows to start
and stop daemons for a quick throw-away usage. This is typically useful when
needing these daemons to run integration testing. It originaly evolved from
its precussor overtest.

%prep
%setup

%build
export SETUPTOOLS_SCM_PRETEND_VERSION=%version
%pyproject_build

%install
%pyproject_install

cp -av %oname/drivers %buildroot%python3_sitelibdir/%oname

%check
export PYTHONPATH=%buildroot%python3_sitelibdir
%pyproject_run_pytest

%files
%doc README.rst
%_bindir/%oname
%python3_sitelibdir/%oname
%python3_sitelibdir/%oname-%version.dist-info

%changelog
