%define oname Paste

%def_with check

Name: python3-module-paste
Version: 3.10.1
Release: alt2

Summary: Tools for using a Web Server Gateway Interface stack

License: MIT
Group: Development/Python
Url: https://pypi.org/project/Paste
Vcs: https://github.com/pasteorg/paste

Source: %name-%version.tar
# https://github.com/pasteorg/paste/issues/107
Patch0: paste-3.10.1-tests-ignore-pkg_resources-warning.patch
BuildArch: noarch

BuildRequires(pre): rpm-build-python3
BuildRequires: python3-module-setuptools
BuildRequires: python3-module-wheel
%if_with check
BuildRequires: python3-module-pytest
%endif

%py3_provides Paste

%add_python3_req_skip scgi hotshot rfc822
%add_python3_req_skip flup.middleware.session hotshot.stats
# FIXME:mask python2 modules
%add_python3_req_skip cStringIO thread urlparse

%add_python3_self_prov_path %buildroot%python3_sitelibdir/paste/wsgilib.py

%description
These provide several pieces of "middleware" (or filters) that can be
nested to build web applications. Each piece of middleware uses the
WSGI (PEP 333) interface, and should be compatible with other
middleware based on those interfaces.

%prep
%setup
%autopatch -p1

%build
%pyproject_build

%install
%pyproject_install
# hack for autocreate "provides python3(paste)"
touch %buildroot%python3_sitelibdir/paste/__init__.py

%check
%pyproject_run_pytest -v

%files
%python3_sitelibdir/paste/
%python3_sitelibdir/%{pyproject_distinfo paste}/

%changelog
