%define _unpackaged_files_terminate_build 1
%define pypi_name paramiko

%define add_python_extra() \
%{expand:%%package -n %%name+%1 \
Summary: %%summary \
Group: Development/Python3 \
Requires: %%name \
%%pyproject_runtimedeps_metadata_extra %1 \
%%description -n %%name+%1' \
Extra "%1" for %%pypi_name. \
%%files -n %%name+%1 \
}

%def_with check

Name: python3-module-%pypi_name
Version: 4.0.0
Release: alt1
Summary: SSH2 protocol for python
License: LGPL-2.1
Group: Development/Python3
Url: https://pypi.org/project/paramiko/
VCS: https://github.com/paramiko/paramiko.git
BuildArch: noarch
Source: %name-%version.tar
Source1: %pyproject_deps_config_name
Patch: %name-%version-alt.patch
AutoReq: yes, nopython3
%pyproject_runtimedeps_metadata
BuildRequires(pre): rpm-build-pyproject
%pyproject_builddeps_build
%if_with check
BuildRequires: /dev/pts
# not packaged
%add_pyproject_deps_check_filter codespell
%pyproject_builddeps_metadata_extra gssapi
%pyproject_builddeps_check
# manually installed (.circleci/config.yml)
BuildRequires: python3-module-k5test
%endif

%description
paramiko is a module for python that implements the SSH2 protocol for secure
(encrypted and authenticated) connections to remote machines. It is written
entirely in python (no C or platform-dependent code).

%add_python_extra gssapi

%prep
%setup
%patch -p1
%pyproject_deps_resync_build
%pyproject_deps_resync_metadata
%if_with check
%pyproject_deps_resync_check_depgroup dev
%endif

%build
%pyproject_build

%install
%pyproject_install

%check
%pyproject_run -- inv test

%files
%doc README.rst
%python3_sitelibdir/paramiko/
%python3_sitelibdir/%{pyproject_distinfo %pypi_name}/

%changelog
