%define oname pandas

%def_disable check
%def_without docs

Name: python3-module-%oname
Version: 2.3.3
Release: alt1
Summary: Python Data Analysis Library
License: BSD-3-Clause
Group: Development/Python3

Url: https://pandas.pydata.org
Vcs: https://github.com/pandas-dev/pandas.git

Source: %name-%version.tar
Patch1: pandas-fix-generate-version.patch
Patch2: pandas-alt-remove-tests-dependency.patch

BuildRequires(pre): rpm-build-python3
BuildRequires: gcc-c++
BuildRequires: python3-devel
BuildRequires: libnumpy-py3-devel
BuildRequires: python3-module-Cython
BuildRequires: python3-module-numpy
BuildRequires: python3-module-mesonpy
BuildRequires: meson
BuildRequires: python3-module-setuptools
BuildRequires: python3-module-wheel
%if_enabled check
BuildRequires: python3-module-pytest
BuildRequires: python3-module-pytest-xdist
BuildRequires: python3-module-numpy-testing
BuildRequires: python3-module-pytz
BuildRequires: python3-module-dateutil
BuildRequires: tzdata
BuildRequires: python3-module-numexpr
%endif
%if_with docs
BuildRequires(pre): rpm-macros-sphinx3
BuildRequires: python3-module-objects.inv
BuildRequires: pandoc
BuildRequires: xvfb-run python3(nbsphinx)
BuildRequires: python3-module-notebook
BuildRequires: python3(numpydoc) python3(matplotlib.sphinxext) python3(matplotlib.sphinxext.plot_directive)
BuildRequires: python3-module-sphinx python3-module-sphinx-sphinx-build-symlink
%endif

%add_python3_req_skip feather
%add_python3_req_skip numba
%add_python3_req_skip numba.extending
%add_python3_req_skip numba.core
%add_python3_req_skip numba.core.datamodel
%add_python3_req_skip numba.core.extending
%add_python3_req_skip numba.core.imputils
%add_python3_req_skip pyarrow
%py3_requires pytz dateutil numpy sqlalchemy numexpr
%py3_requires scipy bs4 xlrd openpyxl xlsxwriter xlwt
%py3_requires tables

%description
pandas is an open source, BSD-licensed library providing
high-performance, easy-to-use data structures and data analysis tools
for the Python programming language.

%package tests
Summary: Tests for pandas
Group: Development/Python3
Requires: %name = %EVR
%py3_requires numpy.ma.testutils pymysql psycopg2

%description tests
pandas is an open source, BSD-licensed library providing
high-performance, easy-to-use data structures and data analysis tools
for the Python programming language.

This package contains tests for pandas.

%package docs
Summary: Documentation for pandas
Group: Development/Documentation
BuildArch: noarch
Requires: %name = %EVR

%description docs
pandas is an open source, BSD-licensed library providing
high-performance, easy-to-use data structures and data analysis tools
for the Python programming language.

This package contains documentation for pandas.

%prep
%setup
%patch1 -p1
%patch2 -p1

sed -i "s/@VERSION@/%version/" generate_version.py

%if_with docs
%prepare_sphinx3 doc
ln -s ../objects.inv doc/source/
%endif

%build
%add_optflags -fno-strict-aliasing
%pyproject_build

%install
%pyproject_install

%if_with docs
pushd doc
PYTHONPATH=$(echo ../build/lib.*) xvfb-run ./make.py html
popd
%endif

%check
mkdir -p _empty
cd _empty
export PYTHONPATH=%buildroot%python3_sitelibdir
py.test-3 -n auto \
	  --no-strict-data-files \
	  -m 'not single_cpu and not network and not db and not slow and not clipboard' \
	  -k "\
	  not test_array_inference[data7-expected7] \
	  and not test_scalar_unary[numexpr-pandas]" \
	  '%buildroot%python3_sitelibdir/pandas/tests'

%files
%doc *.md
%python3_sitelibdir/%oname
%python3_sitelibdir/%oname-%version.dist-info
%exclude %python3_sitelibdir/*/tests
%exclude %python3_sitelibdir/*/testing.py
%exclude %python3_sitelibdir/*/_testing*
%exclude %python3_sitelibdir/*/conftest.py
%exclude %python3_sitelibdir/*/*/test*
%exclude %python3_sitelibdir/*/*/_test*
%exclude %python3_sitelibdir/*/*/conftest.*
%exclude %python3_sitelibdir/*/*/*/test*
%exclude %python3_sitelibdir/*/*/*/_test*

%files tests
%python3_sitelibdir/*/tests
%python3_sitelibdir/*/testing.py
%python3_sitelibdir/*/_testing*
%python3_sitelibdir/*/conftest.py
%python3_sitelibdir/*/*/test*
%python3_sitelibdir/*/*/_test*
%python3_sitelibdir/*/*/conftest.*
%python3_sitelibdir/*/*/*/test*
%python3_sitelibdir/*/*/*/_test*

%if_with docs
%files docs
%doc doc/build/html
%endif

%changelog
