%define oname oslo.utils
%def_with check
%def_with docs

Name: python3-module-%oname
Version: 9.1.0
Release: alt1

Summary: OpenStack Oslo Utility library

License: Apache-2.0
Group: Development/Python3
Url: https://pypi.org/project/oslo.utils

Source: %oname-%version.tar
Source1: %oname.watch

BuildArch: noarch

Provides: python3-module-oslo-utils = %EVR

BuildRequires(pre): rpm-build-python3
BuildRequires: python3-module-setuptools
BuildRequires: python3-module-wheel
BuildRequires: python3-module-pbr >= 6.1.0
BuildRequires: python3-module-oslo.i18n >= 3.15.3
BuildRequires: python3-module-iso8601 >= 0.1.11
BuildRequires: python3-module-netaddr >= 0.10.0
BuildRequires: python3-module-debtcollector >= 1.2.0
BuildRequires: python3-module-pyparsing >= 2.1.0
BuildRequires: python3-module-packaging >= 20.4

%if_with check
BuildRequires: python3-module-eventlet >= 0.18.2
BuildRequires: python3-module-fixtures >= 3.0.0
BuildRequires: python3-module-testscenarios >= 0.4
BuildRequires: python3-module-testtools >= 2.2.0
BuildRequires: python3-module-oslotest >= 3.2.0
BuildRequires: python3-module-ddt >= 1.0.1
BuildRequires: python3-module-stestr >= 2.0.0
BuildRequires: python3-module-coverage >= 4.0
BuildRequires: python3-module-oslo.config >= 5.2.0
BuildRequires: python3-module-psutil >= 3.2.2
BuildRequires: python3-module-tzdata >= 2022.4
BuildRequires: qemu-img
%endif

%if_with docs
BuildRequires: python3-module-sphinx
BuildRequires: python3-module-openstackdocstheme
%endif

%description
The Oslo utils library provides support for common utility type functions,
such as encoding, exception handling, string manipulation, and time handling.

%package tests
Summary: Tests for %oname
Group: Development/Python3
Requires: %name = %EVR

%description tests
This package contains tests for %oname.

%if_with docs
%package doc
Summary: Documentation for %oname
Group: Development/Documentation
Provides: python3-module-oslo-utils-doc = %EVR

%description doc
This package contains documentation for %oname.
%endif

%prep
%setup -n %oname-%version

# Remove bundled egg-info
rm -rfv *.egg-info

%build
%pyproject_build

%if_with docs
export PYTHONPATH="$PWD"
# generate html docs
sphinx-build-3 doc/source html
# generate man page
sphinx-build-3 -b man doc/source man
# remove the sphinx-build leftovers
rm -rf html/.{doctrees,buildinfo}
%endif

%install
%pyproject_install

%if_with docs
# install man page
install -pDm 644 man/osloutils.1 %buildroot%_man1dir/osloutils.1
%endif

%check
# skip test failing with netaddr > 1.2.0
%__python3 -m stestr run --exclude-regex '(oslo_utils.tests.test_netutils.NetworkUtilsTest.test_is_valid_ip)'

%files
%doc LICENSE AUTHORS ChangeLog *.rst
%python3_sitelibdir/oslo_utils
%python3_sitelibdir/%{pyproject_distinfo %oname}/
%exclude %python3_sitelibdir/oslo_utils/tests

%files tests
%python3_sitelibdir/oslo_utils/tests

%if_with docs
%files doc
%doc LICENSE *.rst html
%_man1dir/osloutils.1.xz
%endif

%changelog
