%define oname oslo.reports
%def_with check
%def_with docs

Name: python3-module-%oname
Version: 3.6.0
Release: alt1

Summary: OpenStack Oslo reports library

License: Apache-2.0
Group: Development/Python3
Url: https://pypi.org/project/oslo.reports

Source: %oname-%version.tar
Source1: %oname.watch

BuildArch: noarch

Provides: python3-module-oslo-reports = %EVR

BuildRequires(pre): rpm-build-python3
BuildRequires: python3-module-setuptools
BuildRequires: python3-module-wheel
BuildRequires: python3-module-pbr >= 2.0.0
BuildRequires: python3-module-jinja2 >= 2.10
BuildRequires: python3-module-oslo.serialization >= 2.18.0
BuildRequires: python3-module-psutil >= 3.2.2
BuildRequires: python3-module-oslo.i18n >= 3.15.3
BuildRequires: python3-module-oslo.utils >= 3.33.0

%if_with check
BuildRequires: python3-module-oslo.config >= 5.1.0
BuildRequires: python3-module-hacking >= 3.0.1
BuildRequires: python3-module-oslotest >= 3.2.0
BuildRequires: python3-module-stestr >= 2.0.0
BuildRequires: python3-module-greenlet >= 0.4.15
BuildRequires: python3-module-coverage >= 4.0
BuildRequires: /proc
%endif

%if_with docs
BuildRequires: python3-module-sphinx
BuildRequires: python3-module-openstackdocstheme >= 1.18.1
BuildRequires: python3-module-sphinxcontrib-apidoc
BuildRequires: python3-module-oslo.config >= 5.1.0
%endif

%description
When things go wrong in (production) deployments of OpenStack collecting
debug data is a key first step in the process of triaging & ultimately
resolving the problem. Projects like Nova has extensively used logging
capabilities which produce a vast amount of data. This does not, however,
enable an admin to obtain an accurate view on the current live state
of the system. For example, what threads are running, what config parameters
are in effect, and more.

The project oslo.reports hosts a general purpose error report generation
framework, known as the "guru meditation report" to address the issues
described above.

%package tests
Summary: Tests for %oname
Group: Development/Python3
Requires: %name = %EVR

%description tests
This package contains tests for %oname.

%if_with docs
%package doc
Summary: Documentation for %oname
Group: Development/Documentation
Provides: python3-module-oslo-reports-doc = %EVR

%description doc
This package contains documentation for %oname.
%endif

%prep
%setup -n %oname-%version

# Remove bundled egg-info
rm -rfv *.egg-info

%build
%pyproject_build

%if_with docs
export PYTHONPATH="$PWD"
# generate html docs
sphinx-build-3 doc/source html
# generate man page
sphinx-build-3 -b man doc/source man
# remove the sphinx-build leftovers
rm -rf html/.{doctrees,buildinfo}
%endif

%install
%pyproject_install

%if_with docs
# install man page
install -pDm 644 man/osloreports.1 %buildroot%_man1dir/osloreports.1
%endif

%check
%__python3 -m stestr run

%files
%doc LICENSE AUTHORS ChangeLog *.rst
%python3_sitelibdir/oslo_reports
%python3_sitelibdir/%{pyproject_distinfo %oname}/
%exclude %python3_sitelibdir/oslo_reports/tests

%files tests
%python3_sitelibdir/oslo_reports/tests

%if_with docs
%files doc
%doc LICENSE *.rst html
%_man1dir/osloreports.1.xz
%endif

%changelog
