%define _unpackaged_files_terminate_build 1
%define pypi_name nltk
%define mod_name %pypi_name

%def_enable check

Name: python3-module-%pypi_name
Version: 3.9.1
Release: alt3
Summary: Python modules for Natural Language Processing (NLP)
License: Apache-2.0
Group: Development/Python3
Url: http://www.nltk.org
Vcs: https://github.com/nltk/nltk.git
BuildArch: noarch
Source: %name-%version.tar
Source1: %pyproject_deps_config_name
# apply only for tests on RPM build
Patch0: skip_nltk_data_tests.patch
Patch1: %name-%version-alt.patch
%pyproject_runtimedeps_metadata
# optional deps, not packaged yet
%filter_from_requires /python3\(\.[[:digit:]]\)\?(twython\(\..*\)\?)/d
BuildRequires(pre): rpm-build-pyproject
%pyproject_builddeps_build
%if_enabled check
# not packaged yet
%add_pyproject_deps_check_filter 'gensim$'
%add_pyproject_deps_check_filter 'mdit-plain$'
%add_pyproject_deps_check_filter 'twython$'
%pyproject_builddeps_metadata
%pyproject_builddeps_check
BuildRequires: python3-modules-sqlite3
%endif

%description
NLTK -- the Natural Language Toolkit -- is a suite of open source Python
modules, data sets, and tutorials supporting research and development in
Natural Language Processing.

%prep
%setup
%patch1 -p1
%pyproject_deps_resync_build
%pyproject_deps_resync_metadata
%if_enabled check
%pyproject_deps_resync_check_pipreqfile requirements-ci.txt
%endif

%build
%pyproject_build

%install
%pyproject_install

# don't package tests
rm -r %buildroot%python3_sitelibdir/*/test

%check
patch -p1 < %PATCH0
%pyproject_run_pytest -vra nltk --ignore nltk/test/unit/test_downloader.py

%files
%_bindir/nltk
%python3_sitelibdir/%mod_name/
%python3_sitelibdir/%{pyproject_distinfo %pypi_name}/

%changelog
