%define oname nitime

%def_with check

Name: python3-module-%oname
Version: 0.11
Release: alt1

Summary: Nitime: timeseries analysis for neuroscience data

License: BSD-3-Clause
Group: Development/Python3
URL: https://pypi.org/project/nitime
VCS: https://github.com/nipy/nitime

BuildArch: noarch

Source: %name-%version.tar

BuildRequires(pre): rpm-build-python3
BuildRequires: libnumpy-py3-devel
BuildRequires: python3-module-setuptools
BuildRequires: python3-module-setuptools_scm
BuildRequires: python3-module-wheel

%if_with check
BuildRequires: python3-module-pytest
BuildRequires: python3-module-scipy
BuildRequires: python3-module-numpy-testing
BuildRequires: python3-module-matplotlib
%endif

%description
Nitime is library of tools and algorithms for the analysis of
time-series data from neuroscience experiments. It contains a
implementation of numerical algorithms for time-series analysis both in
the time and spectral domains, a set of container objects to represent
time-series, and auxiliary objects that expose a high level interface to
the numerical machinery and make common analysis tasks easy to express
with compact and semantically clear code.

%package tests
Summary: Tests for Nitime
Group: Development/Python3
Requires: %name = %EVR

%description tests
Nitime is library of tools and algorithms for the analysis of
time-series data from neuroscience experiments. It contains a
implementation of numerical algorithms for time-series analysis both in
the time and spectral domains, a set of container objects to represent
time-series, and auxiliary objects that expose a high level interface to
the numerical machinery and make common analysis tasks easy to express
with compact and semantically clear code.

This package contains tests for Nitime.

%prep
%setup

%build
export SETUPTOOLS_SCM_PRETEND_VERSION=%version
%pyproject_build

%install
%pyproject_install

%check
# https://github.com/nipy/nitime/issues/214
%pyproject_run_pytest -k'not test_timeseries'

%files
%doc LICENSE README.txt THANKS
%python3_sitelibdir/%oname
%python3_sitelibdir/%oname-%version.dist-info
%exclude %python3_sitelibdir/*/tests
%exclude %python3_sitelibdir/*/*/tests

%files tests
%python3_sitelibdir/*/tests
%python3_sitelibdir/*/*/tests

%changelog
