%define _unpackaged_files_terminate_build 1
%define pypi_name netCDF4
%def_with check

Name: python3-module-%pypi_name
Version: 1.7.3
Release: alt1

Summary: Python/numpy interface to netCDF library (versions 3 and 4)
License: BSD / MIT
Group: Development/Python3
Url: https://pypi.python.org/pypi/netCDF4/
Vcs: https://github.com/Unidata/netcdf4-python.git

Source0: %name-%version.tar
Source1: %pyproject_deps_config_name
%pyproject_runtimedeps_metadata

Provides: python3-module-%{pep503_name %pypi_name} = %EVR

BuildRequires(pre): rpm-build-pyproject
BuildRequires: libnetcdf-devel
BuildRequires: zlib-devel
BuildRequires: libjpeg-devel
BuildRequires: libcurl-devel
BuildRequires: libnumpy-py3-devel
BuildRequires: libhdf5-devel
# For generating documentation.
BuildRequires: python3-module-pdoc3

%pyproject_builddeps_build

%if_with check
%pyproject_builddeps_metadata
%pyproject_builddeps_metadata_extra tests
BuildRequires: netcdf-tools
BuildRequires: python3-module-numpy-testing
%endif

Conflicts: python-module-%pypi_name
Obsoletes: python-module-%pypi_name

%py3_provides %pypi_name

%description
netCDF version 4 has many features not found in earlier versions of the
library and is implemented on top of HDF5. This module can read and
write files in both the new netCDF 4 and the old netCDF 3 format, and
can create files that are readable by HDF5 clients. The API modelled
after Scientific.IO.NetCDF, and should be familiar to users of that
module.

Most new features of netCDF 4 are implemented, such as multiple
unlimited dimensions, groups and zlib data compression. All the new
numeric data types (such as 64 bit and unsigned integer types) are
implemented. Compound and variable length (vlen) data types are
supported, but the enum and opaque data types are not. Mixtures of
compound and vlen data types (compound types containing vlens, and vlens
containing compound types) are not supported.

%package docs
Summary: Documentation for %pypi_name
Group: Development/Documentation
BuildArch: noarch

%description docs
netCDF version 4 has many features not found in earlier versions of the
library and is implemented on top of HDF5. This module can read and
write files in both the new netCDF 4 and the old netCDF 3 format, and
can create files that are readable by HDF5 clients. The API modelled
after Scientific.IO.NetCDF, and should be familiar to users of that
module.

Most new features of netCDF 4 are implemented, such as multiple
unlimited dimensions, groups and zlib data compression. All the new
numeric data types (such as 64 bit and unsigned integer types) are
implemented. Compound and variable length (vlen) data types are
supported, but the enum and opaque data types are not. Mixtures of
compound and vlen data types (compound types containing vlens, and vlens
containing compound types) are not supported.

This package contains documentation for %pypi_name.

%prep
%setup
%pyproject_deps_resync_build
%pyproject_deps_resync_metadata

%build
%pyproject_build

%pyproject_run -- pdoc3 --html --output-dir ./docs/ netCDF4

%install
%pyproject_install

%check
pushd test
export NO_NET=1

export PYTHONPATH=%buildroot%python3_sitelibdir
%__python3 run_all.py
popd

%files
%doc LICENSE
%_bindir/*
%python3_sitelibdir/netCDF4/
%python3_sitelibdir/%{pyproject_distinfo %pypi_name}

%files docs
%doc docs/netCDF4/index.html

%changelog
