%define _unpackaged_files_terminate_build 1
%define mname martian

%def_without check

Name: python3-module-%mname
Version: 1.3
Release: alt1

Summary: A library to grok configuration from Python code
License: ZPLv2.1
Group: Development/Python3
# Source-git: https://github.com/zopefoundation/martian.git
Url: http://pypi.python.org/pypi/martian
BuildArch: noarch

Source: %name-%version.tar

BuildRequires(pre): rpm-build-python3
BuildRequires: python3-module-zope.interface

%if_with check
BuildRequires: python3-module-tox
BuildRequires: python3-module-virtualenv
BuildRequires: python3-module-zope.testing
BuildRequires: python3-module-zope.testrunner
BuildRequires: python3-module-coverage
%endif


%description
Martian is a library that allows the embedding of configuration
information in Python code. Martian can then grok the system and do the
appropriate configuration registrations. One example of a system that
uses Martian is the system where it originated: Grok
(http://grok.zope.org)

%prep
%setup

%build
%python3_build_debug

%install
%python3_install

%check
export PIP_INDEX_URL=http://host.invalid./

export PYTHONPATH=%buildroot%python3_sitelibdir_noarch:%python3_sitelibdir_noarch:%_libdir/python3/site-packages
TOX_TESTENV_PASSENV='PYTHONPATH' tox.py3 -e py%{python_version_nodots python3} -v

%files
%doc *.txt *.rst
%python3_sitelibdir/%mname
%python3_sitelibdir/%mname-%version-*.egg-info


%changelog
