%def_without bootstrap

%def_with check

%define oname lxml

Name: python3-module-lxml
Version: 6.0.2
Release: alt1

Summary: Powerful and Pythonic XML processing library combining libxml2/libxslt with the ElementTree API

License: BSD-3-Clause AND GPL-2.0-or-later
Group: Development/Python3
URL: https://pypi.org/project/lxml
VCS: https://github.com/lxml/lxml

Source: %name-%version.tar

%if_without bootstrap
# Used for tests only, but depends on lxml itself,
# which is not yet built in a bootstrap environment.
BuildRequires: python3-module-cssselect
# needed for: from lxml.cssselect import CSSSelector
Requires: python3-module-cssselect
%endif

BuildRequires(pre): rpm-build-python3
BuildRequires: libxslt-devel zlib-devel
# see doc/build.txt
BuildRequires: python3-module-Cython >= 0.18
BuildRequires: python3-module-setuptools
BuildRequires: python3-module-wheel

%if_with check
BuildRequires: python3-module-lxml-html-clean
%endif

%description
lxml is a Pythonic, mature binding for the libxml2 and libxslt libraries.
It provides safe and convenient access to these libraries using the ElementTree API.

It extends the ElementTree API significantly to offer support for XPath,
RelaxNG, XML Schema, XSLT, C14N and much more.

%package doc
Summary: Documentation for lxml
Group: Development/Documentation
BuildArch: noarch

%description doc
lxml is a Pythonic, mature binding for the libxml2 and libxslt libraries.  It
provides safe and convenient access to these libraries using the ElementTree
API.

It extends the ElementTree API significantly to offer support for XPath,
RelaxNG, XML Schema, XSLT, C14N and much more.

This package contains documentation for lxml.

%prep
%setup

find -type f -name '*.c' -print -delete >&2

%build
export LC_ALL=en_US.UTF-8
# see Makefile
sed -i 's|/usr/bin/env python.*|/usr/bin/env python3|' \
	update-error-constants.py test.py
sed -i 's|/usr/bin/python|/usr/bin/python3|' \
	doc/rest2latex.py doc/rest2html.py
export WITH_CYTHON=true
%pyproject_build

%install
%pyproject_install

%check
export LC_ALL=en_US.UTF-8
# The tests assume inplace build, so we copy the built library to source-dir.
# If not done that, Python can either import the tests or the extension modules, but not both.
cp -l build/lib.linux-*/lxml/*.so src/lxml/
# The options are: verbose, unit, functional
python3 test.py -vuf

%files
%doc *.txt *.rst
%python3_sitelibdir/%oname
%python3_sitelibdir/%oname-%version.dist-info

%files doc
%doc doc samples

%changelog
