%define  modulename libsass

Name:    python3-module-%modulename
Version: 0.22.0
Release: alt1

Summary: A straightforward binding of libsass for Python
License: MIT
Group:   Development/Python3
URL:     https://github.com/sass/libsass-python

Packager: Andrey Cherepanov <cas@altlinux.org>

BuildRequires(pre): rpm-build-python3
BuildRequires: python3-dev
BuildRequires: gcc-c++
BuildRequires: python3-module-setuptools
BuildRequires: libsass-devel >= 3.4.9

Source:  %modulename-python-%version.tar
Source1: submodules.tar

%set_verify_elf_method strict
%add_python3_req_skip _sass
%filter_from_requires /python3(distutils/d

%description
This package provides a simple Python extension module sass which is
binding LibSass (written in C/C++ by Hampton Catlin and Aaron Leung).
It's very straightforward and there isn't any headache related Python
distribution/deployment. That means you can add just libsass into your
setup.py's install_requires list or requirements.txt file. Need no Ruby
nor Node.js.

%prep
%setup -n %modulename-python-%version
tar xf %SOURCE1
%__subst "s|-lstdc++|-lsass|" setup.py
pkg-config --modversion libsass > .libsass-upstream-version

%build
%add_optflags %(getconf LFS_CFLAGS)
%python3_build

%install
%python3_install

%files
%doc CONTRIBUTING.rst README.rst
%_bindir/pysassc
%python3_sitelibdir/__pycache__/*.pyc
%python3_sitelibdir/*.so
%python3_sitelibdir/sass*
%python3_sitelibdir/pysassc.py
%python3_sitelibdir/*.egg-info

%changelog
