%define _unpackaged_files_terminate_build 1

%define oname launchpadlib

%def_with check

Name: python3-module-launchpadlib
Version: 2.0.0
Release: alt1
Summary: Script Launchpad through its web services interfaces.  Officially supported.
License: LGPL-3
Group: Development/Python3
Url: https://launchpad.net/launchpadlib
Packager: Anatoly Kitaikin <cetus@altlinux.org>
BuildArch: noarch

Source: %name-%version.tar

BuildPreReq: rpm-build-licenses

BuildRequires(pre): rpm-build-python3
BuildRequires: python3-module-wheel
BuildRequires: python3-module-setuptools
%if_with check
BuildRequires: python3-module-httplib2
BuildRequires: python3-module-lazr.uri
BuildRequires: python3-module-lazr.restfulclient
BuildRequires: python3-module-distro
BuildRequires: python3-module-testresources
BuildRequires: python3-module-pytest
%endif

%py3_provides launchpadlib

%description
launchpadlib is a standalone Python library for scripting Launchpad through
its web services interface.  It is the officially supported bindings to the
Launchpad web service, but there may be third party bindings that provide
scriptability for other languages.

This module is built for python %_python_version

%package tests
Summary: launchpadlib tests
Group: Development/Python3
Requires: %name = %EVR

%description tests
This package contain tools and test suites for testing launchpadlib.

%prep
%setup

%build
%pyproject_build

%install
%pyproject_install

%check
%pyproject_run_pytest -v

%files
%doc CONTRIBUTING.rst README.rst NEWS.rst
%python3_sitelibdir/%oname
%python3_sitelibdir/%{pyproject_distinfo %oname}
%exclude %python3_sitelibdir/%oname/tests

%files tests
%python3_sitelibdir/%oname/tests

%changelog
