%define _unpackaged_files_terminate_build 1

%define oname kombu

%def_disable test
# ModuleNotFoundError: No module named 'sphinx_celery'
%def_without doc

Name: python3-module-%oname
Epoch: 1
Version: 5.3.5
Release: alt2

Group: Development/Python3
License: BSD-3-Clause
Summary: Kombu is an AMQP messaging framework for Python
URL: https://pypi.org/project/kombu/
VCS: https://github.com/celery/kombu/

Source: %name-%version.tar

# Patches from Debian
Patch11: 0001-Remove-image-from-remote-donation-site-privacy-issue.patch

# https://github.com/celery/kombu/issues/1653
Patch21: kombu-Pyro5-support.patch

# librabbitmq is not packaged (yet?)
%filter_from_requires /python3(librabbitmq\(\..*\)\?)/d

BuildRequires(pre): rpm-build-python3
# build backend and its deps
BuildRequires: python3(setuptools)
BuildRequires: python3(wheel)

%if_enabled test
# dependencies
BuildRequires: python3(amqp)
BuildRequires: python3(vine)

BuildRequires: python3(pytest)
BuildRequires: python3(pytz)
BuildRequires: python3(msgpack)
BuildRequires: python3(yaml)
BuildRequires: python3(boto3)
BuildRequires: python3(pymongo)
BuildRequires: python3(zstandard)
BuildRequires: python3(brotli)
BuildRequires: python3(kazoo)
BuildRequires: python3(pycurl)
BuildRequires: python3(consul)
BuildRequires: python3(Pyro5)
BuildRequires: python3(hypothesis)

# failed tests
#BuildRequires: python3(librabbitmq)
#BuildRequires: python3(etcd)
#BuildRequires: python3(redis)
#BuildRequires: python3(sqlalchemy)
%endif

%if_with doc
BuildRequires(pre): rpm-macros-sphinx3
BuildRequires: python3-module-sphinx
%endif

%add_python3_req_skip azure.core.exceptions azure.servicebus azure.servicebus.exceptions azure.servicebus.management

%description
AMQP is the Advanced Message Queuing Protocol, an open standard protocol
for message orientation, queuing, routing, reliability and security.

One of the most popular implementations of AMQP is `RabbitMQ`_.

The aim of `Kombu` is to make messaging in Python as easy as possible by
providing an idiomatic high-level interface for the AMQP protocol, and also
provide proven and tested solutions to common messaging problems.

%package docs
Summary: Documentation for %oname
Group: Development/Documentation
BuildArch: noarch

%description docs
AMQP is the Advanced Message Queuing Protocol, an open standard protocol
for message orientation, queuing, routing, reliability and security.

One of the most popular implementations of AMQP is `RabbitMQ`_.

The aim of `Kombu` is to make messaging in Python as easy as possible by
providing an idiomatic high-level interface for the AMQP protocol, and also
provide proven and tested solutions to common messaging problems.

This package contains documentation for %oname.

%prep
%setup
%autopatch -p1

%build
%pyproject_build

%install
%pyproject_install

%if "%_target_libdir_noarch" != "%_libdir"
mv %buildroot%_target_libdir_noarch %buildroot%_libdir
%endif

%if_with doc
%make -C docs html SPHINXBUILD=sphinx-build-3
%endif

%check
# we havent got python3(azure) yet
%pyproject_run_pytest -ra --ignore=t/unit/transport/test_azurestoragequeues.py

%files
%doc README.rst
%python3_sitelibdir/kombu/
%python3_sitelibdir/%{pyproject_distinfo %oname}/

%if_with doc
%files docs
%doc docs/_build/html/*
%endif

%changelog
