%define _unpackaged_files_terminate_build 1
%define pypi_name jupyterlab

%ifarch i586
%def_without check
%else
%def_with check
%endif

Name: python3-module-%pypi_name
Version: 4.4.10
Release: alt1
Summary: JupyterLab computational environment
License: BSD-3-Clause
Group: Development/Python3
Url: https://pypi.org/project/jupyterlab/
BuildArch: noarch
Source: %pypi_name-%version.tar

Requires: python3-module-ipykernel

BuildRequires(pre): rpm-build-python3
BuildRequires: python3-module-hatchling
BuildRequires: python3-module-hatch-jupyter-builder
BuildRequires: npm
%if_with check
BuildRequires: python3-module-pytest
BuildRequires: python3-module-pytest-jupyter
BuildRequires: python3-module-jupyterlab-server
BuildRequires: python3-module-notebook-shim
BuildRequires: python3-module-async-lru
BuildRequires: python3-module-pytest-console-scripts
BuildRequires: python3-module-pytest-timeout
BuildRequires: python3-module-requests-cache
BuildRequires: node
BuildRequires: python3-module-httpx
%endif

%description
An extensible environment for interactive and reproducible computing,
based on the Jupyter Notebook and Architecture.

JupyterLab is the next-generation user interface for Project Jupyter offering
all the familiar building blocks of the classic Jupyter Notebook
(notebook, terminal, text editor, file browser, rich outputs, etc.)
in a flexible and powerful user interface.

%package tests
Summary: Tests for %pypi_name
Group: Development/Python3
Requires: %name = %EVR

%description tests
An extensible environment for interactive and reproducible computing,
based on the Jupyter Notebook and Architecture.

This package contains tests for %pypi_name.

%prep
%setup -n %pypi_name-%version

%build
%pyproject_build

%install
%pyproject_install

# Move config files to proper location
install -d -m 755 %buildroot%_sysconfdir/jupyter/jupyter_notebook_config.d
install -d -m 755 %buildroot%_sysconfdir/jupyter/jupyter_server_config.d
mv %buildroot/usr/etc/jupyter/jupyter_notebook_config.d/jupyterlab.json \
   %buildroot%_sysconfdir/jupyter/jupyter_notebook_config.d
mv %buildroot/usr/etc/jupyter/jupyter_server_config.d/jupyterlab.json \
   %buildroot%_sysconfdir/jupyter/jupyter_notebook_config.d

%check
%pyproject_run_pytest -v \
--deselect=jupyterlab/tests/test_build_api.py::TestBuildAPI::test_clear \
--deselect=jupyterlab/tests/test_build_api.py::TestBuildAPI::test_build \
--deselect=jupyterlab/tests/test_jupyterlab.py::TestExtension::test_build \
--deselect=jupyterlab/tests/test_jupyterlab.py::TestExtension::test_install_and_uninstall_pinned_folder \
--deselect=jupyterlab/tests/test_jupyterlab.py::TestExtension::test_install_and_uninstall_pinned \
--deselect=jupyterlab/tests/test_jupyterlab.py::TestExtension::test_uninstall_core_extension


%files
%doc README.*
%_bindir/*
%dir %_datadir/jupyter
%dir %_datadir/icons/hicolor/scalable
%dir %_datadir/icons/hicolor/scalable/apps
%_datadir/applications/jupyterlab.desktop
%_datadir/icons/hicolor/scalable/apps/jupyterlab.svg
%_datadir/jupyter/lab
%dir %_sysconfdir/jupyter/
%config(noreplace) %_sysconfdir/jupyter/*
%python3_sitelibdir/%pypi_name
%python3_sitelibdir/%{pyproject_distinfo %pypi_name}
%exclude %python3_sitelibdir/%pypi_name/tests
%exclude %python3_sitelibdir/%pypi_name/pytest_plugin.py
%exclude %python3_sitelibdir/%pypi_name/browser_check.py

%files tests
%python3_sitelibdir/%pypi_name/tests
%python3_sitelibdir/%pypi_name/pytest_plugin.py
%python3_sitelibdir/%pypi_name/browser_check.py

%changelog
