%define _unpackaged_files_terminate_build 1
%define pypi_name joblib

%def_with check

Name: python3-module-%pypi_name
Version: 1.5.2
Release: alt1

Summary: Lightweight pipelining: using Python functions as pipeline jobs
License: BSD
Group: Development/Python3
Url: https://pypi.org/project/joblib/
Vcs: https://github.com/joblib/joblib
BuildArch: noarch
Source: %name-%version.tar
Source1: debundler.py.in
Source2: %pyproject_deps_config_name
Patch0: %name-%version-alt.patch
%pyproject_runtimedeps_metadata
%pyproject_runtimedeps -- vendored
# manually manage dependencies with metadata
AutoReq: yes, nopython3
BuildRequires(pre): rpm-build-pyproject
%pyproject_builddeps_build
%if_with check
%pyproject_builddeps_metadata
%pyproject_builddeps -- vendored
# synced to continuous_integration/install.sh
BuildRequires: python3-module-pytest
BuildRequires: python3-module-pytest-asyncio
BuildRequires: python3-module-threadpoolctl
%endif

%description
Joblib is a set of tools to provide lightweight pipelining in Python. In
particular, joblib offers:

  1. transparent disk-caching of the output values and lazy
     re-evaluation (memoize pattern)
  2. easy simple parallel computing
  3. logging and tracing of the execution

Joblib is optimized to be fast and robust in particular on large data
and has specific optimizations for numpy arrays.

%prep
%setup
%autopatch -p1
# gen vendored list for upstream
set -o pipefail
%__python3 - <<-'EOF' | sort -u > _vendor.txt
import pkgutil
for mod in pkgutil.iter_modules(["joblib/externals"]):
    print(mod.name)
EOF
%pyproject_deps_resync vendored pip_reqfile _vendor.txt

VENDORED_PATH='joblib/externals'
UNVENDORED_PATH="$VENDORED_PATH/__init__.py"
rm -r "$VENDORED_PATH"
mkdir "$VENDORED_PATH"
cp "%SOURCE1" "$UNVENDORED_PATH"
sed -i \
    -e 's/@VENDORED_ROOT@/"joblib.externals"/' \
    -e 's/@VENDORED_FAKE_PACKAGES@/None/' \
    "$UNVENDORED_PATH"

%pyproject_deps_resync_build
%pyproject_deps_resync_metadata

%build
%pyproject_build

%install
%pyproject_install

%check
%pyproject_run_pytest -ra

%files
%doc CHANGES.rst README.rst
%python3_sitelibdir/joblib/
%python3_sitelibdir/%{pyproject_distinfo %pypi_name}/
%exclude %python3_sitelibdir/joblib/test*
%exclude %python3_sitelibdir/joblib/__pycache__/test*

%changelog
