%define oname jmespath
%def_disable doc

%def_with check

Name: python3-module-%oname
Version: 1.0.1
Release: alt1
Summary: JSON Matching Expressions
License: MIT
Group: Development/Python3
Url: https://pypi.python.org/pypi/jmespath/

# https://github.com/boto/jmespath.git
Source: %name-%version.tar
Patch1: %oname-0.9.3-alt-docs.patch
BuildArch: noarch

BuildRequires(pre): rpm-build-python3
%{?_enable_doc:BuildRequires: python3-module-sphinx python3-module-guzzle_sphinx_theme}
%if_with check
BuildRequires: python3-module-pytest
BuildRequires: python3-module-hypothesis
%endif

%description
JMESPath allows you to declaratively specify how to extract elements
from a JSON document.

%package docs
Summary: Documentation for %oname
Group: Development/Documentation
BuildArch: noarch

%description docs
JMESPath allows you to declaratively specify how to extract elements
from a JSON document.

This package contains documentation for %oname.

%prep
%setup
%patch1 -p1

%build
%python3_build

%install
%python3_install
%if_enabled doc
sphinx-build-3 -b html -d build/doctrees doc/source build/html
%endif

%check
export PYTHONPATH=%buildroot%python3_sitelibdir
py.test-3

%files
%doc *.rst
%_bindir/*
%python3_sitelibdir/*

%if_enabled doc
%files docs
%doc build/html/*
%endif

%changelog
