%define _unpackaged_files_terminate_build 1
%def_with check

Name: python3-module-jeepney
Version: 0.8.0
Release: alt2
License: MIT
Group: Development/Python3
Url: https://gitlab.com/takluyver/jeepney
Source: jeepney-%version.tar

Summary: Pure Python DBus interface
BuildRequires(pre): rpm-build-python3

# build backend and its deps
BuildRequires: python3(flit_core)

%if_with check
BuildRequires: python3(pytest)
BuildRequires: python3(testpath)
BuildRequires: python3-module-async-timeout
BuildRequires: python3-module-pytest-asyncio
BuildRequires: python3-module-trio
%endif

BuildArch: noarch

%description
Jeepney is a pure Python implementation of D-Bus messaging. It has an
I/O-free core, and integration modules for different event loops.

D-Bus is an inter-process communication system, mainly used in Linux.

%package extras
Group: Development/Python3
Summary: Extra dependencies of jeepney

%description extras
Extra dependencies for jeepney, namely tests and trio I/O

%prep
%setup -n jeepney-%version

%build
%pyproject_build

%install
%pyproject_install

%check
%tox_create_default_config
%tox_check_pyproject

%files
%python3_sitelibdir_noarch/jeepney/
%python3_sitelibdir_noarch/%{pyproject_distinfo jeepney}/
%exclude %python3_sitelibdir_noarch/jeepney/io/trio.py
%exclude %python3_sitelibdir_noarch/jeepney/tests
%exclude %python3_sitelibdir_noarch/jeepney/io/tests

%files extras
%python3_sitelibdir_noarch/jeepney/io/trio.py
%python3_sitelibdir_noarch/jeepney/tests
%python3_sitelibdir_noarch/jeepney/io/tests

%changelog
