%global pypi_name iso8601

%def_with check

Name: python3-module-%pypi_name
Version: 2.1.0
Release: alt2

Summary: Simple module to parse ISO 8601 dates

Group: Development/Python3
License: MIT
URL: https://pypi.org/project/iso8601
VCS: https://github.com/micktwomey/pyiso8601

Source0: %name-%version.tar

BuildRequires: rpm-build-python3
BuildRequires: python3-module-setuptools
BuildRequires: python3-module-poetry

%if_with check
BuildRequires: python3-module-pytest
BuildRequires: python3-module-hypothesis
BuildRequires: python3-module-pytz
%endif

BuildArch: noarch

%description
This module parses the most common forms of ISO 8601 date strings (e.g.
2007-01-14T20:34:22+00:00) into datetime objects.

%prep
%setup

%build
%pyproject_build

%install
%pyproject_install

%check
%pyproject_run_pytest

%files
%doc LICENSE README.rst
%python3_sitelibdir/%pypi_name/
%python3_sitelibdir/%pypi_name-%version.dist-info/
%exclude %python3_sitelibdir/%pypi_name/test_iso8601.py
%exclude %python3_sitelibdir/%pypi_name/__pycache__/test_iso8601.cpython*

%changelog
