%define _unpackaged_files_terminate_build 1

%define oname ipykernel

%def_with check

Name: python3-module-%oname
Version: 7.0.1
Release: alt1

Summary: IPython Kernel for Jupyter
License: BSD-3-Clause
Group: Development/Python3
Url: https://pypi.org/project/ipykernel/
VCS: https://github.com/ipython/ipykernel.git

Source: %name-%version.tar

BuildArch: noarch

BuildRequires(pre): rpm-build-python3
BuildRequires: python3-module-hatchling
BuildRequires: python3-module-jupyter_client
%if_with check
BuildRequires: python3-module-pytest
BuildRequires: python3-module-comm
BuildRequires: python3-module-pytest-asyncio
BuildRequires: python3-module-pytest-timeout
BuildRequires: python3-module-ipython
BuildRequires: python3-module-flaky
BuildRequires: python3-module-nest-asyncio
BuildRequires: python3-module-psutil
BuildRequires: python3-module-zmq
BuildRequires: python3-module-traitlets
BuildRequires: python3-module-tornado
BuildRequires: /proc
BuildRequires: /dev/pts
BuildRequires: python3-module-ipyparallel
BuildRequires: python3-module-trio
BuildRequires: python3-module-pexpect
BuildRequires: python3-module-matplotlib-inline
BuildRequires: python3-module-pytest-cov
BuildRequires: python3-module-numpy-tests
%endif

%add_python3_req_skip gtk gobject

%description
This package provides the IPython kernel for Jupyter.

%package tests
Summary: Tests for %oname
Group: Development/Python3
Requires: %name = %EVR

%description tests
This package provides the IPython kernel for Jupyter.

This package contains tests for %oname.

%prep
%setup

sed -i 's/--color=yes//' pyproject.toml

%build
%pyproject_build

%install
%pyproject_install

# ipykernel.tests.utils need by python3-module-numba
cp -r tests/ %buildroot%python3_sitelibdir/%oname/

%check
%pyproject_run_pytest -v tests/

%files
%doc README.*
%_datadir/jupyter
%python3_sitelibdir/ipykernel_launcher.py
%python3_sitelibdir/__pycache__/ipykernel_launcher.*
%python3_sitelibdir/%oname
%python3_sitelibdir/%{pyproject_distinfo %oname}
%exclude %python3_sitelibdir/%oname/tests

%files tests
%python3_sitelibdir/%oname/tests

%changelog
