%define _unpackaged_files_terminate_build 1
%define pypi_name importlib-metadata

%def_with check

Name: python3-module-%pypi_name
Version: 8.7.0
Release: alt1
Summary: Library to access the metadata for a Python package
License: Apache-2.0
Group: Development/Python3
Url: https://pypi.org/project/importlib-metadata/
VCS: https://github.com/python/importlib_metadata.git
BuildArch: noarch
Source: %name-%version.tar
Source1: %pyproject_deps_config_name
Patch: %name-%version-alt.patch
%pyproject_runtimedeps_metadata

# PyPI name(dash, underscore)
%py3_provides %pypi_name
Provides: python3-module-importlib_metadata = %EVR
Obsoletes: python3-module-importlib_metadata <= 1.5.0-alt1

BuildRequires(pre): rpm-build-pyproject
%pyproject_builddeps_build

%if_with check
# pytest-perf is not packaged and perf tests are skipped anyway
%add_pyproject_deps_check_filter pytest-perf
%pyproject_builddeps_metadata_extra test

# internal CPython's test package
BuildRequires: python3(test)
%endif

%description
Library to access the metadata for a Python package.

This package supplies third-party access to the functionality of
importlib.metadata including improvements added to subsequent Python versions.

New features are introduced in this third-party library and later merged into
CPython.

%prep
%setup
%patch -p1
%pyproject_scm_init
%pyproject_deps_resync_build
%pyproject_deps_resync_metadata

%build
%pyproject_build

%install
%pyproject_install

%check
%pyproject_run_pytest -vra --ignore exercises.py

%files
%doc README.rst
%python3_sitelibdir/importlib_metadata/
%python3_sitelibdir/%{pyproject_distinfo %pypi_name}/

%changelog
