%define _unpackaged_files_terminate_build 1
%define oname hupper

%def_with check

Name:           python3-module-%oname
Version:        1.12.1
Release:        alt1

Summary:        Integrated process monitor for developing servers
Group:          Development/Python3
License:        MIT
BuildArch:      noarch
URL:            https://pypi.org/project/hupper
VCS:            https://github.com/Pylons/hupper.git

Source: %name-%version.tar

BuildRequires(pre): rpm-build-python3
BuildRequires: python3-module-setuptools
BuildRequires: python3-module-wheel
%if_with check
BuildRequires: python3-module-pytest
BuildRequires: python3-module-pytest-cov
%endif


%description
hupper is an integrated process monitor that will track changes
to any imported Python files in sys.modules as well as custom paths.
When files are changed the process is restarted.

%prep
%setup

sed -i 's|#!/usr/bin/env python|#!/usr/bin/env python3|' \
    $(find ./ -name '*.py')

%build
%pyproject_build

%install
%pyproject_install

%check
%pyproject_run_pytest -v

%files
%doc CHANGES.rst CONTRIBUTING.rst LICENSE.txt README.rst
%python3_sitelibdir/%oname
%python3_sitelibdir/%{pyproject_distinfo %oname}
%_bindir/*


%changelog
