%define oname hdf5storage

%def_with check

Name: python3-module-%oname
Version: 0.2.2
Release: alt1

Summary: Utilities to read/write Python types to/from HDF5 files, including MATLAB v7.3 MAT files
License: BSD-2-Clause
Group: Development/Python3
Url: https://pypi.org/project/hdf5storage
Vcs: https://github.com/jclds139/hdf5storage

Source: %name-%version.tar

BuildArch: noarch

BuildRequires(pre): rpm-build-python3
BuildRequires: python3-module-poetry-core
%if_with check
BuildRequires: python3-module-pytest
BuildRequires: python3-module-h5py
BuildRequires: python3-module-numpy-testing
BuildRequires: python3-module-scipy
BuildRequires: python3-module-matplotlib
%endif

%py3_provides %oname
%py3_requires numpy h5py


%description
This Python package provides high level utilities to read/write a
variety of Python types to/from HDF5 (Heirarchal Data Format) formatted
files. This package also provides support for MATLAB MAT v7.3 formatted
files, which are just HDF5 files with a different extension and some
extra meta-data.

%prep
%setup

sed -i '/addopts/d' pyproject.toml

%build
%pyproject_build

%install
%pyproject_install

%check
%ifarch i586
%pyproject_run_pytest -k "not test_read_empty"
%else
%pyproject_run_pytest -v
%endif

%files
%doc README.*
%python3_sitelibdir/%oname
%python3_sitelibdir/%{pyproject_distinfo %oname}

%changelog
