%define pypi_name hacking

%def_with check

Name: python3-module-%pypi_name
Version: 7.0.0
Release: alt1

Summary: OpenStack Hacking Guideline Enforcement

License: Apache-2.0
Group: Development/Python3
BuildArch: noarch
URL: https://pypi.org/project/hacking
VCS: https://github.com/openstack/hacking

Source: %name-%version.tar
Patch0: %name-%version-alt.patch

BuildRequires(pre): rpm-build-python3
BuildRequires: python3(pbr)

BuildRequires: python3(setuptools)
BuildRequires: python3(wheel)

%if_with check
BuildRequires: python3(flake8)

BuildRequires: python3(stestr)
BuildRequires: python3(ddt)
%endif

%py3_requires flake8

%description
hacking is a set of flake8 plugins that test and enforce the OpenStack
Style Guidlines.

%prep
%setup
%autopatch -p1
sed -i -e '/flake8/d' requirements.txt

%build
# https://docs.openstack.org/pbr/latest/user/packagers.html#versioning
export PBR_VERSION=%version
%pyproject_build

%install
export PBR_VERSION=%version
%pyproject_install

# don't ship tests
rm -rv %buildroot%python3_sitelibdir/hacking/tests/

%check
export PBR_VERSION=%version
%tox_check_pyproject

%files
%doc *.rst doc/source/*.rst
%python3_sitelibdir/hacking
%python3_sitelibdir/%{pyproject_distinfo %pypi_name}

%changelog
