%define _unpackaged_files_terminate_build 1
%define pypi_name gssapi

%def_with check

Name: python3-module-%pypi_name
Version: 1.10.0
Release: alt1

Summary: Python GSSAPI Wrapper
License: ISC
Group: Development/Python3
VCS: https://github.com/pythongssapi/python-gssapi.git
Url: https://pypi.org/project/gssapi/

Source: %name-%version.tar
Source1: %pyproject_deps_config_name
Patch: %name-%version-alt.patch
# manually manage runtime dependencies with metadata
AutoReq: yes, nopython3
%pyproject_runtimedeps_metadata
Requires: libkrb5 >= 1.15
BuildRequires(pre): rpm-build-pyproject
%pyproject_builddeps_build
BuildRequires: libkrb5-devel >= 1.15
%if_with check
%pyproject_builddeps_metadata
%pyproject_builddeps_check
%endif

%description
Python-GSSAPI provides both low-level and high level wrappers around the GSSAPI
C libraries. While it focuses on the Kerberos mechanism, it should also be
useable with other GSSAPI mechanisms.

%prep
%setup
%patch -p1
%pyproject_deps_resync_build
%pyproject_deps_resync_metadata
%if_with check
%pyproject_deps_resync_check_pipreqfile test-requirements.txt
%endif

%build
%add_optflags -fno-strict-aliasing
%pyproject_build

%install
%pyproject_install

%check
# see ci/test.sh
%pyproject_run -- bash -s <<-'ENDUNITTEST'
set -eu
cd gssapi/tests
python -m unittest
ENDUNITTEST

%files
%doc LICENSE.txt README.rst
%python3_sitelibdir/gssapi/
%python3_sitelibdir/%{pyproject_distinfo %pypi_name}/

%exclude %python3_sitelibdir/gssapi/tests/

%changelog
