%define _unpackaged_files_terminate_build 1
%define pypi_name ghp-import

%def_with check

Name: python3-module-%pypi_name
Version: 2.1.0
Release: alt1
Summary: Copy your docs directly to the gh-pages branch
License: Apache-2.0
Group: Development/Python3

Url: https://pypi.org/project/ghp-import

# https://github.com/davisp/ghp-import.git
Source0: %name-%version.tar
BuildArch: noarch

BuildRequires(pre): rpm-build-python3

# build backend and its deps
BuildRequires: python3(setuptools)
BuildRequires: python3(wheel)

%if_with check
# install_requires:
BuildRequires: python3(dateutil)
%endif

Provides: ghp-import.py3 = %EVR
Obsoletes: ghp-import.py3 < 0.5.5

# file conflict: /usr/bin/ghp-import
Conflicts: ghp-import

# PyPI name(dash, underscore)
%py3_provides %pypi_name

Requires: git

%description
As part of gunicorn, Benoit Chesneau and I have been starting to look at
how to host documentation. There's the obvious method of using GitHub's
post-receive hook to trigger doc builds and rsync to a webserver, but we
ended up wanting to try out github's hosting to make the whole interface
a bit more robust.

%prep
%setup

%build
%pyproject_build

%install
%pyproject_install

%check
# upstream doesn't provide tests, at least, install it and run `--help`
cat > tox.ini <<EOF
[testenv]
usedevelop=True
commands =
    {envbindir}/ghp-import --help
EOF
%tox_check_pyproject

%files
%doc LICENSE README.md
%_bindir/ghp-import
%python3_sitelibdir/ghp_import.py
%python3_sitelibdir/__pycache__/ghp_import.*
%python3_sitelibdir/%{pyproject_distinfo %pypi_name}/

%changelog
