%define _unpackaged_files_terminate_build 1
%define pypi_name geopy
%define mod_name %pypi_name

%def_with check

Name: python3-module-%pypi_name
Version: 2.4.1
Release: alt1

Summary: Python Geocoding Toolbox
License: MIT
Group: Development/Python3
Url: https://pypi.python.org/pypi/geopy/
Vcs: https://github.com/geopy/geopy
BuildArch: noarch
Source: %name-%version.tar
Source1: %pyproject_deps_config_name
%pyproject_runtimedeps_metadata
BuildRequires(pre): rpm-build-pyproject
%pyproject_builddeps_build
%if_with check
%pyproject_builddeps_metadata_extra dev-test
# setup.py: `docutils` from sphinx is used in tests
# sphinx is filtered by rpm-build-pyproject
BuildRequires: python3-module-sphinx
%endif

%description
geopy is a Python client for several popular geocoding web services.

geopy makes it easy for Python developers to locate the coordinates of
addresses, cities, countries, and landmarks across the globe using
third-party geocoders and other data sources.

geopy includes geocoder classes for the OpenStreetMap Nominatim, Google
Geocoding API (V3), and many other geocoding services.

%prep
%setup
%pyproject_deps_resync_build
%pyproject_deps_resync_metadata

%build
%pyproject_build

%install
%pyproject_install

%check
%pyproject_run_pytest -vra --skip-tests-requiring-internet

%files
%doc README.*
%python3_sitelibdir/%mod_name/
%python3_sitelibdir/%{pyproject_distinfo %pypi_name}/

%changelog
