%define modulename fontTools

Name: python3-module-fonttools
Version: 4.60.1
Release: alt1

Summary: Converts OpenType and TrueType fonts to and from XML

Group: Development/Tools
License: LGPL
URL: https://github.com/fonttools/fonttools/

Packager: Vitaly Lipatov <lav@altlinux.ru>

# Source-url: https://github.com/fonttools/fonttools/archive/%version.tar.gz
Source: %name-%version.tar

BuildArch: noarch

BuildRequires(pre): rpm-build-python3

BuildRequires: xorg-sdk
#BuildRequires: python3-module-setuptools python3-module-numpy

# TODO: the requirements are different for PyPy and Cython
%if 0
# generated by 'epm restore --dry-run' from fonttools/requirements.txt
%py3_use brotlipy >= 0.7.0
%py3_use munkres >= 1.1.4
%py3_use zopfli >= 0.1.6
#py3_use ufolib2 >= 0.6.2
%endif

%if_with test
# generated by 'epm restore --dry-run' from fonttools/dev-requirements.txt
%py3_buildrequires pytest >= 3.0
%py3_buildrequires tox >= 2.5
%py3_buildrequires bump2version >= 0.5.6
%py3_buildrequires sphinx >= 1.5.5
%py3_buildrequires mypy >= 0.782
%endif

# TODO: add skia-pathops
%add_python3_req_skip pathops

# optional
%add_python3_req_skip sympy matplotlib mpl_toolkits.mplot3d


%global desc \
FontTools/TTX is a library to manipulate font files from Python. It supports \
reading and writing of TrueType/OpenType fonts, reading and writing of AFM \
files, reading (and partially writing) of PS Type 1 fonts. The package also \
contains a tool called TTX which converts TrueType/OpenType fonts to and \
from an XML-based format.

%description
%desc

%package -n fonttools
Group: Development/Python3
Summary: Python 3 fonttools
Requires: %name = %EVR

%description -n fonttools
%desc

%prep
%setup
sed -i '1d' Lib/fontTools/mtiLib/__init__.py

%build
# TODO: --with-cython
%python3_build

%install
%python3_install
rm -fv %buildroot%python3_sitelibdir/%modulename/pens/quartzPen.py

%files
%python3_sitelibdir/%modulename/
%python3_sitelibdir/fonttools-%version-py%__python3_version.egg-info

%files -n fonttools
%_bindir/ttx
%_bindir/pyft*
%_bindir/fonttools
%_man1dir/*


%changelog
