%define _unpackaged_files_terminate_build 1
%define oname flask-login

%def_enable check

Name: python3-module-%oname
Version: 0.6.3
Release: alt2.1

Summary: User session management for Flask
License: MIT
Group: Development/Python3
Url: https://pypi.org/project/Flask-Login/
Vcs: https://github.com/maxcountryman/flask-login

BuildArch: noarch

Source: %name-%version.tar
Patch: flask-login-0.6.3-utcnow-fix.patch

BuildRequires(pre): rpm-build-python3
BuildRequires: python3-module-setuptools
BuildRequires: python3-module-wheel
%if_enabled check
BuildRequires: python3-module-flask
BuildRequires: python3-module-blinker
BuildRequires: python3-module-semantic_version
BuildRequires: python3-module-asgiref
BuildRequires: python3-module-pytest
%endif

%description
Flask-Login provides user session management for Flask. It handles the
common tasks of logging in, logging out, and remembering your users'
sessions over extended periods of time.

Flask-Login is not bound to any particular database system or
permissions model. The only requirement is that your user objects
implement a few methods, and that you provide a callback to the
extension capable of loading users from their ID.

%prep
%setup
%patch -p1

%build
%pyproject_build

%install
%pyproject_install

%check
%pyproject_run_pytest -vra

%files
%doc CHANGES.md LICENSE README.md
%python3_sitelibdir/flask_login/
%python3_sitelibdir/%{pyproject_distinfo %oname}/

%changelog
