%global oname fixtures

%def_with check

Name: python3-module-%oname
Version: 4.2.6
Release: alt1

Summary: Fixtures, reusable state for writing clean tests and more

License: Apache-2.0 or BSD-3-Clause
Group: Development/Python3
URL: https://pypi.org/project/fixtures
VCS: https://github.com/testing-cabal/fixtures

Source: %name-%version.tar

BuildArch: noarch

BuildRequires(pre): rpm-build-python3

BuildRequires: python3-module-wheel
BuildRequires: python3-module-hatchling
BuildRequires: python3-module-hatch-vcs

%if_with check
BuildRequires: python3-module-testtools
%endif

%description
Fixtures defines a Python contract for reusable state / support logic,
primarily for unit testing. Helper and adaption logic is included to
make it easy to write your own fixtures using the fixtures contract.
Glue code is provided that makes using fixtures that meet the Fixtures
contract in unittest compatible test cases easy and straight forward.

%prep
%setup

%build
export SETUPTOOLS_SCM_PRETEND_VERSION=%version
%pyproject_build

%install
%pyproject_install

%check
%tox_check_pyproject

%files
%doc README.rst GOALS NEWS Apache-2.0 BSD COPYING
%python3_sitelibdir/%oname
%python3_sitelibdir/%oname-%version.dist-info

%changelog
