%define _unpackaged_files_terminate_build 1
%define pypi_name filelock
%define mod_name %pypi_name

%def_with check

Name: python3-module-%pypi_name
Version: 3.20.0
Release: alt1
Summary: A platform independent file lock for Python
License: Unlicense
Group: Development/Python3
Url: https://pypi.org/project/filelock/
VCS: https://github.com/tox-dev/py-filelock
BuildArch: noarch
Source: %name-%version.tar
Source1: %pyproject_deps_config_name
# manually manage runtime dependencies with metadata
AutoReq: yes, nopython3
%pyproject_runtimedeps_metadata
BuildRequires(pre): rpm-build-pyproject
%pyproject_builddeps_build

%if_with check
%add_pyproject_deps_check_filter diff-cover
%pyproject_builddeps_metadata
%pyproject_builddeps_check
%endif

%description
This package contains a single module, which implements a platform independent
file locking mechanism for Python.

The lock includes a lock counter and is thread safe. This means, when locking
the same lock object twice, it will not block.

%prep
%setup
%pyproject_scm_init
%pyproject_deps_resync_build
%pyproject_deps_resync_metadata
%if_with check
%pyproject_deps_resync_check_depgroup test
%endif

%build
%pyproject_build

%install
%pyproject_install

%check
%pyproject_run_pytest -vra tests

%files
%doc README.md
%python3_sitelibdir/%mod_name/
%python3_sitelibdir/%{pyproject_distinfo %pypi_name}/

%changelog
