%define oname fanstatic

%def_with docs
%def_with check

Name: python3-module-%oname
Version: 1.5
Release: alt1
Summary: Flexible static resources for web applications
License: BSD-3-Clause
Group: Development/Python3
Url: https://pypi.org/project/fanstatic/
VCS: https://github.com/fanstatic/fanstatic/

Source: %name-%version.tar
BuildArch: noarch

BuildRequires(pre): rpm-build-python3
%if_with docs
BuildRequires(pre): rpm-macros-sphinx3
BuildRequires: python3-module-sphinx
%endif
BuildRequires: python3-module-setuptools
BuildRequires: python3-module-wheel
%if_with check
BuildRequires: python3-module-pytest
BuildRequires: python3-module-cssmin
BuildRequires: python3-module-webob
%endif

%description
Fanstatic is a smart static resource publisher for Python. For more
information on what it's about and how to use it, see:
http://fanstatic.org

%package docs
Summary: Documentation for fanstatic
Group: Development/Documentation

%description docs
Fanstatic is a smart static resource publisher for Python. For more
information on what it's about and how to use it, see:
http://fanstatic.org

This package contains documentation for fanstatic.

%package pickles
Summary: Pickles for fanstatic
Group: Development/Python3

%description pickles
Fanstatic is a smart static resource publisher for Python. For more
information on what it's about and how to use it, see:
http://fanstatic.org

This package contains pickles for fanstatic.

%package tests
Summary: Tests for fanstatic
Group: Development/Python3
Requires: %name = %EVR

%description tests
Fanstatic is a smart static resource publisher for Python. For more
information on what it's about and how to use it, see:
http://fanstatic.org

This package contains tests for fanstatic.

%prep
%setup

%if_with docs
%prepare_sphinx3 .
ln -s ../objects.inv docs/
%endif

%build
%pyproject_build

%install
%pyproject_install

%if_with docs
export PYTHONPATH=%buildroot%python3_sitelibdir
%make SPHINXBUILD=sphinx-build-3 -C docs html
%make SPHINXBUILD=sphinx-build-3 -C docs pickle

cp -fR docs/_build/pickle %buildroot%python3_sitelibdir/fanstatic/
%endif

%check
%pyproject_run_pytest -v

%files
%doc LICENSE.txt *.rst
%_bindir/fanstatic-compile
%python3_sitelibdir/%oname
%python3_sitelibdir/%{pyproject_distinfo %oname}
%exclude %python3_sitelibdir/%oname/tests
%if_with docs
%exclude %python3_sitelibdir/%oname/pickle

%files docs
%doc docs/_build/html/*

%files pickles
%dir %python3_sitelibdir/%oname
%python3_sitelibdir/%oname/pickle
%endif

%files tests
%python3_sitelibdir/%oname/tests

%changelog
