%define pypi_name ezdxf

%def_with check

Name: python3-module-%pypi_name
Version: 1.4.3
Release: alt1

Summary: Python 3 package for manipulating DXF drawings

License: MIT
Group: Development/Python3
URL: https://pypi.org/project/ezdxf
VCS: https://github.com/mozman/ezdxf

Source: %name-%version.tar

BuildRequires(pre): rpm-build-python3
# build backend and its deps
BuildRequires: python3(setuptools)
BuildRequires: python3(wheel)
BuildRequires: python3(Cython)
BuildRequires: python3(fontTools)

%if_with check
# dependencies
BuildRequires: python3(pyparsing)
BuildRequires: python3(typing_extensions)

BuildRequires: python3(pytest)
BuildRequires: python3(geomdl)
%endif

%description
A Python package to create and modify DXF drawings, independent from the
DXF version.

%prep
%setup

%build
%pyproject_build

%install
%pyproject_install

%check
# test_distance_from_start fails on ix86
%pyproject_run_pytest -ra tests integration_tests -k'not test_distance_from_start'

%files
%doc LICENSE README.md
%_bindir/ezdxf
%python3_sitelibdir/%pypi_name
%python3_sitelibdir/%{pyproject_distinfo %pypi_name}

%changelog
