%define _unpackaged_files_terminate_build 1
%define oname execnet
%define descr \
execnet provides carefully tested means to ad-hoc interact with Python \
interpreters across version, platform and network barriers. It provides \
a minimal and fast API targetting the following uses: \
\
* distribute tasks to local or remote processes \
* write and deploy hybrid multi-process applications \
* write scripts to administer multiple hosts

%def_with check

Name: python3-module-%oname
Version: 2.1.1
Release: alt1

Summary: Rapid multi-Python deployment
Group: Development/Python3

License: MIT
Url: https://pypi.python.org/pypi/execnet/
Source: %name-%version.tar
Patch: %name-%version-alt.patch
BuildArch: noarch

%py3_provides %oname

%add_python3_req_skip win32event win32evtlogutil win32service
%add_python3_req_skip win32serviceutil register
# hasn't got version for Python3
%add_python3_req_skip rlcompleter2

%filter_from_provides /^python3(execnet\.script\.shell)/d
# IndexError: list index out of range
%filter_from_provides /^python3(execnet\.script\.socketserverservice)/d
# No module named 'win32serviceutil'
%filter_from_provides /^python3(execnet\.script\.quitserver)/d
# No module named 'execnet.quitserver'
%filter_from_provides /^python3(execnet\.script\.xx)/d
# depends from rlcompleter2

BuildRequires(pre): rpm-macros-sphinx3 rpm-build-python3
BuildRequires: python3-module-setuptools_scm
BuildRequires: python3-module-apipkg
BuildRequires: python3-module-sphinx
BuildRequires: python3-module-hatchling
BuildRequires: python3-module-hatch-vcs

%if_with check
BuildRequires: python3-module-tox
BuildRequires: python3-module-pytest-timeout
%endif

%description
%descr

%prep
%setup
%patch -p1

%build
# SETUPTOOLS_SCM_PRETEND_VERSION: when defined and not empty,
# its used as the primary source for the version number in which
# case it will be a unparsed string
export SETUPTOOLS_SCM_PRETEND_VERSION=%version
%pyproject_build

%install
export SETUPTOOLS_SCM_PRETEND_VERSION=%version
%pyproject_install

%check
%tox_check_pyproject

%files
%doc LICENSE *.rst
%python3_sitelibdir/%oname
%python3_sitelibdir/%oname-%version.dist-info

%changelog
