%define oname eventlet

%ifnarch armh ppc64le
%def_with check
%else
%def_without check
%endif

%def_without docs

Name: python3-module-%oname
Version: 0.40.3
Release: alt1

Summary: Highly concurrent networking library
License: MIT
Group: Development/Python3

Url: https://pypi.org/project/eventlet/

# Source-url: %__pypi_url %oname
Source: %name-%version.tar

BuildArch: noarch

Requires: python3-module-dns
Requires: python3-module-greenlet

BuildRequires(pre): rpm-build-python3
BuildRequires: python3-module-hatchling
BuildRequires: python3-module-hatch-vcs
%if_with docs
BuildRequires(pre): rpm-macros-sphinx3
BuildRequires: python3-module-sphinx
BuildRequires: python3-module-greenlet
BuildRequires: python3-module-dns
%endif
%if_with check
BuildRequires: python3-module-pytest
BuildRequires: python3-module-greenlet
BuildRequires: python3-module-dns
BuildRequires: python3-module-psycopg2
BuildRequires: python3-module-zmq
%endif

%add_python3_req_skip stackless

# required by strange pylib.py:
%add_python3_req_skip py.magic

%description
Eventlet is a concurrent networking library for Python that allows you
to change how you run your code, not how you write it.

It uses epoll or libevent for highly scalable non-blocking I/O.
Coroutines ensure that the developer uses a blocking style of
programming that is similar to threading, but provide the benefits of
non-blocking I/O. The event dispatch is implicit, which means you can
easily use Eventlet from the Python interpreter, or as a small part of a
larger application.

%if_with docs
%package pickles
Summary: Pickles for Eventlet
Group: Development/Python

%description pickles
Eventlet is a concurrent networking library for Python that allows you
to change how you run your code, not how you write it.

It uses epoll or libevent for highly scalable non-blocking I/O.
Coroutines ensure that the developer uses a blocking style of
programming that is similar to threading, but provide the benefits of
non-blocking I/O. The event dispatch is implicit, which means you can
easily use Eventlet from the Python interpreter, or as a small part of a
larger application.

This package contains pickles for Eventlet.

%package docs
Summary: Documentation for Eventlet
Group: Development/Documentation
BuildArch: noarch

%description docs
Eventlet is a concurrent networking library for Python that allows you
to change how you run your code, not how you write it.

It uses epoll or libevent for highly scalable non-blocking I/O.
Coroutines ensure that the developer uses a blocking style of
programming that is similar to threading, but provide the benefits of
non-blocking I/O. The event dispatch is implicit, which means you can
easily use Eventlet from the Python interpreter, or as a small part of a
larger application.

This package contains documentation for Eventlet.
%endif

%prep
%setup

# requires thrift, python 2.7 only
rm -rv eventlet/zipkin

# remove obsoleted tsafe (ALT bug 45443)
rm -v eventlet/green/OpenSSL/tsafe.py

%if_with docs
%prepare_sphinx3 .
ln -s ../objects.inv doc/
%endif

%build
%pyproject_build

%install
%pyproject_install

%if_with docs
export PYTHONPATH=%buildroot%python3_sitelibdir
%make -C doc html SPHINXBUILD=sphinx-build-3
%endif

%check
%pyproject_run_pytest -v -k "\
not test_dns_methods_are_green \
and not test_noraise_dns_tcp \
and not test_clear \
and not test_raise_dns_tcp"

%files
%doc AUTHORS NEWS README.rst
%python3_sitelibdir/eventlet-%version.dist-info
%python3_sitelibdir/eventlet/

%if_with doc
%files docs
%doc examples doc/_build/html
%endif

%changelog
