%global modname etcd
%global srcname python-%{modname}
%global __ospython %{_bindir}/python3
%global python3_sitelib %(%{__ospython} -c "from distutils.sysconfig import get_python_lib; print(get_python_lib())")

%def_with check

Name:           python3-module-%modname
Version:        0.4.5
Release:        alt5.1
Summary:        A python client library for etcd
Group:          System/Libraries
License:        MIT
URL:            http://pypi.python.org/pypi/%{srcname}
Source0:        %{name}-%{version}.tar
Patch:          remove-nose.patch

BuildArch:      noarch

BuildRequires:  python3-module-setuptools
BuildRequires:  python3-module-wheel
BuildRequires:  python3-module-dns
BuildRequires:  python3-module-urllib3
BuildRequires:  python3-module-OpenSSL
%if_with check
BuildRequires: python3-module-pytest
%endif
Requires:       python3-module-dns
Requires:       python3-module-urllib3
Obsoletes:      python3-module-python-etcd
Provides:       python3-module-python-etcd
%{?python_provide:%python_provide python3-etcd}

%description
Client library for interacting with an etcd service, providing Python
access to the full etcd REST API.  Includes authentication, accessing
and manipulating shared content, managing cluster members, and leader
election.

%prep
%setup
%patch -p1

%build
%pyproject_build

%install
%pyproject_install

%check
%pyproject_run_pytest -v src/etcd/tests/unit/ -k 'not test_acquired and not test_machines'

# This seems to require a newer python3-mock than what's currently available
# in F23, and even Rawhide.  If I let it download mock-1.3.0 from the Python
# Package Index (pypi) then tests pass.
#%%{__python3} setup.py test

%files
%doc README.rst
%doc LICENSE.txt
%{python3_sitelib}/*
%exclude %python3_sitelib/*/tests

%changelog
