%define pypi_name ephem

%def_with check

Name: python3-module-%pypi_name
Version: 4.2
Release: alt1

Summary: Compute positions of the planets and stars
License: MIT
Group: Development/Python
URL: https://pypi.org/project/ephem
VCS: https://github.com/brandon-rhodes/pyephem

Source: %name-%version.tar

BuildRequires: rpm-build-python3
BuildRequires: python3(setuptools)
BuildRequires: python3(wheel)

%if_with check
BuildRequires: python3(pytest)
%endif

%description
PyEphem provides an ephem Python package for performing high-precision
astronomy computations. The underlying numeric routines are coded in C
and are the same ones that drive the popular XEphem astronomy
application, whose author, Elwood Charles Downey, generously gave
permission for their use in PyEphem. The name ephem is short for the
word ephemeris, which is the traditional term for a table giving the
position of a planet, asteroid, or comet for a series of dates.

%prep
%setup
# remove shebangs in test files
sed -i '1{/env python/d}' ephem/tests/test_*.py

%build
%pyproject_build

%install
%pyproject_install

%check
%pyproject_run_pytest %buildroot%python3_sitelibdir/%pypi_name/tests -k 'not JPLTest'

%files
%doc *.rst ephem/doc/*.rst issues
%python3_sitelibdir/%pypi_name
%python3_sitelibdir/%pypi_name-%version.dist-info
%exclude %python3_sitelibdir/%pypi_name/doc
%exclude %python3_sitelibdir/%pypi_name/tests

%changelog
