%define _unpackaged_files_terminate_build 1
%define pypi_name pyenchant
%define mod_name enchant

%def_with check

Name: python3-module-enchant
Version: 3.2.2
Release: alt2
Summary: Python bindings for the Enchant spellchecking system
License: LGPLv2+
Group: Development/Python3
Url: https://pypi.org/project/pyenchant/
Vcs: https://github.com/pyenchant/pyenchant/
BuildArch: noarch
Source: %name-%version.tar
Source1: %pyproject_deps_config_name
# used dynamically
Requires: libenchant
%pyproject_runtimedeps_metadata
# mapping from PyPI name
Provides: python3-module-%{pep503_name %pypi_name} = %EVR
BuildRequires(pre): rpm-build-pyproject
%pyproject_builddeps_build
%if_with check
%pyproject_builddeps_metadata
%pyproject_builddeps_check
BuildRequires: hunspell-en_US
%endif
BuildRequires: libenchant-devel

%description
PyEnchant combines all the functionality of the underlying Enchant
library with the flexibility of Python and a nice "Pythonic"
object-oriented interface. It also aims to provide some higher-level
functionality than is available in the C API.

%prep
%setup
%pyproject_deps_resync_build
%pyproject_deps_resync_metadata
%if_with check
%pyproject_deps_resync_check_tox tox.ini testenv
%endif

%build
%pyproject_build

%install
%pyproject_install

%check
%pyproject_run_pytest -ra

%files
%python3_sitelibdir/%mod_name/
%python3_sitelibdir/%{pyproject_distinfo %pypi_name}/
%exclude %python3_sitelibdir/%mod_name/checker/*CheckerDialog*

%changelog
