%define oname elementpath

%def_with check

Name: python3-module-%oname
Version: 5.0.4
Release: alt1

Summary: XPath 1.0 and 2.0 selectors for Python's ElementTree XML data

License: MIT
Group: Development/Python3
URL: https://pypi.org/project/elementpath
VCS: https://github.com/sissaschool/elementpath

Source: %name-%version.tar

BuildRequires(pre): rpm-build-python3
BuildRequires: python3-module-setuptools
BuildRequires: python3-module-wheel

%if_with check
BuildRequires: python3-module-pytest
BuildRequires: python3-module-lxml
%endif

BuildArch: noarch

%description
%oname provides XPath 1.0 and 2.0 selectors for Python's ElementTree XML data
structures, both for the standard ElementTree library and for the lxml.etree
library.

%prep
%setup

sed -i 's/license = "MIT"/license = {file = "LICENSE"}/' pyproject.toml
sed -i '/license-files/d' pyproject.toml

%build
%pyproject_build

%install
%pyproject_install

%check
# test_validate_json_to_xml and test_validate_analyzed_string needs xmlschema
%pyproject_run_pytest -k"not test_validate_json_to_xml and \
                         not test_validate_analyzed_string"

%files
%doc LICENSE README.rst
%python3_sitelibdir/%oname
%python3_sitelibdir/%oname-%version.dist-info

%changelog
