%define _unpackaged_files_terminate_build 1
%define modname django-tinymce
%def_with check

Name: python3-module-%modname
Version: 4.0.0
Release: alt1

Summary: A Django app for render a form field as a TinyMCE editor
License: MIT
Group: Development/Python3
Url: https://pypi.org/project/django-tinymce
BuildArch: noarch

Source: %name-%version.tar

BuildRequires(pre): rpm-build-python3
BuildRequires: python3(setuptools)
BuildRequires: python3(wheel)
BuildRequires: python3(sphinx)

%if_with check
BuildRequires: python3(django)
BuildRequires: python3(coverage)
BuildRequires: python3-module-django-dbbackend-sqlite3
%endif

%py3_provides %modname

%description
django-tinymce is a Django application that contains a widget to render a form field as a TinyMCE editor.

%prep
%setup

sed -i 's|sphinx-build|sphinx-build-3|' docs/Makefile

sed -i 's|#!/usr/bin/env python|#!/usr/bin/env python3|' \
    $(find ./ -name '*.py')

%build
%pyproject_build

%check
%tox_check_pyproject

%install
%pyproject_install

export PYTHONPATH=%buildroot%python3_sitelibdir
%make -C docs html

%files
%doc LICENSE.txt README.* docs/.build/html
%python3_sitelibdir/tinymce
%python3_sitelibdir/%{pyproject_distinfo %modname}

%changelog
