%define oname django-taggit
%define mod_name taggit

%def_with check

Name: python3-module-%oname
Version: 6.1.0
Release: alt1

Summary: Simple tagging for django
License: BSD-3-Clause
Group: Development/Python3
Url: https://pypi.python.org/pypi/django-taggit
BuildArch: noarch

# https://github.com/alex/django-taggit.git
Source: %name-%version.tar

BuildRequires(pre): rpm-build-python3
BuildRequires: python3-module-setuptools python3-module-wheel

%if_with check
BuildRequires: python3-module-django
BuildRequires: python3-module-django-dbbackend-sqlite3
BuildRequires: python3-module-djangorestframework
%endif

# self-providing dependency
%add_python3_req_skip library_management
%add_python3_req_skip library_management.models

%description
django-taggit is a reusable Django application for simple tagging.

%prep
%setup

%build
%pyproject_build

%install
%pyproject_install
%find_lang %name

%check
python3 -m django test -v 2 --settings=tests.settings

%files -f %name.lang
%doc AUTHORS LICENSE *.rst docs/*
%python3_sitelibdir/%mod_name/
%python3_sitelibdir/sample_taggit/
%python3_sitelibdir/%{pyproject_distinfo %oname}/

%changelog
