%define _unpackaged_files_terminate_build 1
%define oname dirty-models

%def_with check

Name: python3-module-%oname
Version: 0.12.4
Release: alt1.1
Summary: Dirty models for python 3
License: BSD
Group: Development/Python3
Url: https://pypi.org/project/dirty-models/

# https://github.com/alfred82santa/dirty-models.git
Source: %name-%version.tar
BuildArch: noarch

BuildRequires(pre): rpm-build-python3
BuildRequires: python3(setuptools)
BuildRequires: python3(wheel)

%if_with check
# install_requires=
BuildRequires: python3(dateutil)

BuildRequires: python3(tox)
BuildRequires: python3(tox_console_scripts)
BuildRequires: python3(nose2)
BuildRequires: python3(iso8601)
%endif

# PEP503 normalized name
%py3_provides %oname

%description
Dirty models for python 3.


Features:

* Python 3 package.
* Easy to create a model.
* Non destructive modifications.
* Non false positive modifications.
* Able to restore original data for each field or whole model.
* Access to original data.
* Read only fields.
* Alias for fields.
* Custom getters and setters for each fields.
* Automatic cast value.
* Easy import from/export to dict.
* Basic field type implemented.
* HashMap model. It could be used instead of DynamicModel.
* FastDynamicModel. It could be used instead of DynamicModel. Same
  behavior, better performance.
* Pickable models.
* Datetime fields can use any datetime format using parser and formatter
  functions.
* No database dependent.

%prep
%setup

%build
%pyproject_build

%install
%pyproject_install

%check
%tox_check_pyproject

%files
%doc *.rst
%python3_sitelibdir/dirty_models/
%python3_sitelibdir/dirty_models-%version.dist-info/

%changelog
