%define _unpackaged_files_terminate_build 1
%define pypi_name dill
%define mod_name %pypi_name

%def_with check

Name: python3-module-%pypi_name
Version: 0.4.0
Release: alt1
Summary: Serialize all of Python
License: BSD
Group: Development/Python3
Url: https://pypi.org/project/dill/
Vcs: https://github.com/uqfoundation/dill
BuildArch: noarch
Source: %name-%version.tar
Source1: %pyproject_deps_config_name
# manually manage extra dependencies with metadata
AutoReq: yes, nopython3
%pyproject_runtimedeps_metadata
BuildRequires(pre): rpm-build-pyproject
%pyproject_builddeps_build
%if_with check
%pyproject_builddeps_metadata
%endif
%add_python3_self_prov_path %buildroot%python3_sitelibdir/%mod_name/tests/

%description
Dill extends python's 'pickle' module for serializing and de-serializing
python objects to the majority of the built-in python types.
Dill provides the user the same interface as the 'pickle' module, and also
includes some additional features. In addition to pickling python objects, dill
provides the ability to save the state of an interpreter session in a single
command.

%package -n %name+graph
Summary: %summary
Group: Development/Python3
Requires: %name
%pyproject_runtimedeps_metadata_extra graph
%description -n %name+graph
Extra 'graph' for %pypi_name.

%package -n %name+profile
Summary: %summary
Group: Development/Python3
Requires: %name
%pyproject_runtimedeps_metadata_extra profile
# file conflict on /usr/bin/get_gprof
Conflicts: %name+graph < 0.3.8-alt1
%description -n %name+profile
Extra 'profile' for %pypi_name.

%prep
%setup
%pyproject_deps_resync_build
%pyproject_deps_resync_metadata

%build
%pyproject_build

%install
%pyproject_install
# don't ship tests
rm -r %buildroot%python3_sitelibdir/%mod_name/tests/

%check
%pyproject_run -- python3 dill/tests/__main__.py

%files
%doc README.md
%_bindir/undill
%python3_sitelibdir/%mod_name/
%python3_sitelibdir/%{pyproject_distinfo %pypi_name}/

%files -n %name+graph
%_bindir/get_objgraph

%files -n %name+profile
%_bindir/get_gprof

%changelog
