%define _libexecdir %_prefix/libexec
%define modname dbus-python

%def_enable doc
%def_enable check
%def_disable installed_tests
#%%add_findreq_skiplist %_libexecdir/installed-tests/%modname/test/*.py

Name: python3-module-dbus
Version: 1.4.0
Release: alt1

Summary: Python bindings for D-BUS library
License: MIT
Group: Development/Python3
Url: https://www.freedesktop.org/wiki/Software/DBusBindings

Source: https://dbus.freedesktop.org/releases/dbus-python/dbus-python-%version.tar.xz

%define dbus_ver 1.8
%define glib_ver 2.40
%define python3_ver 3.7

BuildRequires(pre): rpm-macros-meson rpm-build-python3
BuildRequires: meson libdbus-devel >= %dbus_ver libgio-devel >= %glib_ver
BuildRequires: python3-devel python3-module-pygobject3
%{?_enable_check:BuildRequires: /proc dbus-tools dbus-tools-gui glibc-i18ndata python3-module-tappy}
%{?_enable_doc:BuildRequires: python3-module-sphinx python3-module-sphinx_rtd_theme}

%description
D-Bus python bindings for use with python programs.

%package gobject
Summary: Python bindings for D-BUS library
Group: Development/Python
Requires: %name = %EVR

%description gobject
D-Bus bindings for use with python programs
(gobject introspection bindings).

%package -n %modname-devel
Summary: Python bindings for D-BUS library (devel package)
Group: Development/Python3
Provides: python3-module-dbus-devel = %EVR
Provides: python-module-dbus-devel  = %EVR

%description -n %modname-devel
D-Bus python bindings for use with python programs.
Development package.

%package devel-doc
Summary: Development documentation for %modname
Group: Development/Documentation
BuildArch: noarch
Conflicts: %name-devel < %version-%release

%description devel-doc
Development documentation for %modname.

%package tests
Summary: Tests for the %name package
Group: Development/Python3
Requires: %name = %EVR
Requires: dbus-tools

%description tests
This package provides tests programs that can be used to verify
the functionality of the installed python-dbus package.

%prep
%setup -n %modname-%version

%build
%meson \
    %{subst_enable_meson_bool installed_tests installed_tests} \
    %{subst_enable_meson_feature doc doc}
%nil
%meson_build

%install
%meson_install

%check
%__meson_test -t 2

%files
%python3_sitelibdir/*.so
%python3_sitelibdir/dbus/
%doc AUTHORS COPYING NEWS

%exclude %python3_sitelibdir/dbus/gi_service.py
%exclude %python3_sitelibdir/dbus/__pycache__/gi_service.*.pyc

%files gobject
%python3_sitelibdir/dbus/gi_service.py
%python3_sitelibdir/dbus/__pycache__/gi_service.*.pyc

%files -n %modname-devel
%_includedir/dbus-1.0/dbus/%modname.h
%_pkgconfigdir/%modname.pc
%doc doc/*.txt

%if_enabled installed_tests
%files tests
%_libexecdir/installed-tests/%modname/
%_datadir/installed-tests/%modname/
%endif

%if_enabled doc
%files devel-doc
%_docdir/%modname/
%endif

%changelog
