%define  modulename confluent-kafka

%def_with check

Name:    python3-module-%modulename
Version: 2.6.1
Release: alt1.1

Summary: Confluent's Kafka Python Client

License: Apache-2.0
Group:   Development/Python3
URL:     https://github.com/confluentinc/confluent-kafka-python

Packager: Grigory Ustinov <grenka@altlinux.org>

BuildRequires(pre): rpm-build-python3
BuildRequires: librdkafka-devel
BuildRequires: python3-module-setuptools
BuildRequires: python3-module-wheel

%if_with check
BuildRequires: python3-module-pytest
BuildRequires: python3-module-trivup
BuildRequires: python3-module-requests-mock
BuildRequires: python3-module-avro
BuildRequires: python3-module-fastavro
BuildRequires: python3-module-jsonschema
BuildRequires: python3-module-google-api-core
BuildRequires: python3-module-flake8
BuildRequires: python3-module-pytest-timeout
BuildRequires: python3-module-pyrsistent
BuildRequires: python3-module-pyflakes
BuildRequires: python3-module-pyflakes-tests
%endif

Source:  %name-%version.tar

%add_python3_self_prov_path %buildroot%python3_sitelibdir/confluent_kafka/kafkatest/verifiable_client.py

%description
confluent-kafka-python is Confluent's Python client for Apache Kafka
and the Confluent Platform.

%prep
%setup

%build
%pyproject_build

%install
%pyproject_install

%check
# test_alter_consumer_group_offsets_api causes segault
# https://github.com/confluentinc/confluent-kafka-python/issues/1797
# test_kafkaError_unknonw_error needs pluggy < 1.6.0
# https://github.com/confluentinc/confluent-kafka-python/commit/e6cec6b7362761c8792e435c8ae3877f8967ba74
%pyproject_run_pytest --ignore=tests/integration --disable-warnings \
    -k 'not test_alter_consumer_group_offsets_api and not test_kafkaError_unknonw_error'

%files
%doc *.md LICENSE
%python3_sitelibdir/confluent_kafka
%python3_sitelibdir/%{pyproject_distinfo confluent_kafka}

%changelog
